clear all; close all;

% UNITS  1: nominal dollars   2: percent   3: quantity  4: nominal price index

%Mortgage Market
%%%%%%%%%%%%%%%%
D_Mortgage = xlsread('data/MEGAP_data.xlsx','Monthly Mortgage Market');
DATES = D_Mortgage(:,1);
SCONV = D_Mortgage(:,2);
SFHA  = D_Mortgage(:,3);
ORIG  = D_Mortgage(:,5);
MDEBT = D_Mortgage(:,7);
RFS   = D_Mortgage(:,8);
ORIG_RF  = RFS.*ORIG;
ORIG_PUR = (1-RFS).*ORIG;

DATASET.TSERIES = [DATES SCONV SFHA ORIG MDEBT ORIG_RF ORIG_PUR]; 
DATASET.LABEL   = [{'DATES','SCONV', 'SFHA', 'ORIG' ,'MDEBT', 'ORIG_RF', 'ORIG_PUR'}];
DATASET.UNIT    = [0, 2     ,    2,     1 ,     1  ,1 ,1]; 
DATASET.FIGLABELS = [{'Date' ,'Conventional Mortgage Spread','FHA Mortgage Spread',...
    'Mortgage Originations','Residential Mortgage Debt','Mortgage Originations: Refinancing',...
    'Mortgage Originations: Purchase'}];  

% Agency Data
%%%%%%%%%%%%%
D_Agency = xlsread('data/MEGAP_data.xlsx','Monthly Agency Data - SA');
NP       = D_Agency(:,2);
COM      = D_Agency(:,7);
MH       = D_Agency(:,12);
PI       = D_Agency(:,17);
PMH      = MDEBT-MH;

DATASET.TSERIES = [DATASET.TSERIES NP COM MH PI PMH]; 
DATASET.LABEL   = [DATASET.LABEL,{'NP','COM','MH','PI','PMH'}];
% UNITS  1: nominal dollars   2: percent   3: quantity  4: nominal price index
DATASET.UNIT    = [DATASET.UNIT    1,    1 ,   1   , 1 , 1]; 
DATASET.FIGLABELS = [DATASET.FIGLABELS, {'Agency Net Portfolio Purchases',...
    'Agency Net Purchase Commitments','Agency Mortgage Holdings',...
    'Agency Pool Issues','Private Mortgage Holdings'}];  

% Narrative Variables
%%%%%%%%%%%%%%%%%%%%%
D_NARR = xlsread('data/MEGAP_data.xlsx','Figure III');

NARR_EX  = D_NARR(:,2);
NARR_EN  = D_NARR(:,3);
NARR_TOT = NARR_EX+NARR_EN; 

DATASET.TSERIES = [DATASET.TSERIES NARR_EX NARR_EN NARR_TOT]; 
DATASET.LABEL   = [DATASET.LABEL,{'NARR_EX', 'NARR_EN','NARR_TOT'}];
DATASET.UNIT    = [DATASET.UNIT    1,    1 ,   1   1  1 ]; 
DATASET.FIGLABELS = [DATASET.FIGLABELS, {'Narrative Non-Cyclical' ,'Narrative Cyclical',...
                        'Narrative Total'}];  

                    
% Other Variables
%%%%%%%%%%%%%%%%%%
D_Other = xlsread('data/MEGAP_data.xlsx','Other Monthly Variables');

% Macro Variables:
HSTARTS  = D_Other(:,2);
HPRICE   = D_Other(:,3);
HOR      = D_Other(:,4);
INDPRO   = D_Other(:,5);
PINC     = D_Other(:,6);
UNRATE   = D_Other(:,7);
PCE      = D_Other(:,8);
PCEPI    = D_Other(:,9);

DATASET.TSERIES = [DATASET.TSERIES HSTARTS HPRICE HOR INDPRO PINC UNRATE PCE PCEPI]; 
DATASET.LABEL   = [DATASET.LABEL,{'HSTARTS','HPRICE','HOR','INDPRO','PINC','UNRATE','PCE','PCEPI'}];
DATASET.UNIT    = [DATASET.UNIT   3   4  2   3         1     2        1      4 ]; 
DATASET.FIGLABELS = [DATASET.FIGLABELS, {'Housing Starts','House Price Index',...
      'Homeownership Rate','Industrial Production','Personal Income','Unemployment Rate',...
      'Personal Consumption Expenditures','PCE Price Level'}];  

% Interest Rates:  
BAA   = D_Other(:,10);
AAA   = D_Other(:,11);
SBAA  = BAA-AAA;
GS10  = D_Other(:,12);
SAAA  = AAA-GS10;
FF    = D_Other(:,13);
TB3   = D_Other(:,14);
RR    = D_Other(:,15);
RRcum    = nancumsum(RR);
RRcum(isnan(RR)) = NaN;
CONV  = SCONV+GS10;
FHA   = SFHA+GS10;
                   
DATASET.TSERIES = [DATASET.TSERIES CONV FHA AAA BAA SBAA SAAA ...
                                     GS10 FF TB3 RR RRcum  ]; 
DATASET.LABEL   = [DATASET.LABEL,{'CONV','FHA','AAA','BAA','SBAA','SAAA',...
                                    'GS10' ,'FF' ,'TB3','RR','RRcum'}];
DATASET.UNIT    = [DATASET.UNIT   2 2 2 2 2 2 2 2 2 2 2]; 
DATASET.FIGLABELS = [DATASET.FIGLABELS,...
    {'Conventional Mortgage Rate','FHA Mortgage Rate','AAA Corporate Bond Rate',...
     'BAA Corporate Bond Rate','BAA-AAA Spread','AAA-10 year Treasury Spread',...
     '10-year Treasury Rate','Federal Funds Rate','3-month T-bill Rate',...
     'RR Shocks','Cumul. Romer and Romer (2004) Shocks'}];  
                    
% Stock Market Prices:                    
SP500 = D_Other(:,16);
GSE_index = D_Other(:,19);
SP500 = SP500/SP500(350)*100;
GSE_index = GSE_index/GSE_index(350)*100;
index_ba = cumprod(1+D_Other(:,20)/100); % bank index
index_ba = index_ba/index_ba(350)*100;
index_re = cumprod(1+D_Other(:,21)/100); % real estate index
index_re = index_re/index_re(350)*100;
index_fi = cumprod(1+D_Other(:,22)/100); % finance index
index_fi = index_fi/index_fi(350)*100;
index_m  = cumprod(1+(D_Other(:,23)+D_Other(:,26))/100); % market index
index_m  = index_m/index_m(350)*100;
index_f  = cumprod(1+(D_Other(:,26))/100); % risk free index
index_f  = index_f/index_f(350)*100;
FF_SMB   = D_Other(:,24);
FF_HML   = D_Other(:,25);

DATASET.TSERIES = [DATASET.TSERIES SP500 GSE_index index_ba index_re...
                                    index_fi index_m index_f FF_SMB FF_HML]; 
DATASET.LABEL   = [DATASET.LABEL,{'SP500','GSE_index','index_ba','index_re',...
                                    'index_fi','index_m','index_f','FF_SMB','FF_HML'}];
DATASET.UNIT    = [DATASET.UNIT  ,     4 4 4 4 4 4 4 4 4]; 
DATASET.FIGLABELS = [DATASET.FIGLABELS, { 'S&P 500 Index','GSE Stock Index',...
    'Banking Sector Index','Real Estate Sector Index',...
    'Finance Sector Index','Fama French Market Index','Risk-Free Index',...
    'Fama French SMB', 'Fama French HML'}];  

DATASET.MAP = containers.Map(DATASET.LABEL,1:size(DATASET.TSERIES,2));
save DATASET

