load DATASET

PLEVEL = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'PCEPI'})));

% Narrative Measure
%%%%%%%%%%%%%%%%%%%
NARR = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'NARR_EX'})))./PLEVEL;
NARR(isnan(NARR))=0;

% Agency Purchasing Activity Measures
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
NCOMM    = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'COM'})))./PLEVEL;
NPURC    = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'NP' })))./PLEVEL;

% Scaling Variables
%%%%%%%%%%%%%%%%%%%
pinc = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'PINC'})))./PLEVEL;
sel = isnan(pinc)==0;
yy= log(pinc(sel));
trend = (1:length(sel))';
xx= [ones(length(pinc),1) trend ];
bb= xx(sel,:)\yy;
X_PINCT = NaN*zeros(length(sel),1);
X_PINCT(sel) =  exp(xx(sel,:)*bb)*1000;

orig= DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'ORIG'})))./PLEVEL;
sel = isnan(orig)==0;
yy= log(orig(sel));
trend = (1:length(sel))';
xx= [ones(length(orig),1) trend trend.^2 trend.^3];
bb= xx(sel,:)\yy;
X_ORIGT = NaN*zeros(length(sel),1);
X_ORIGT(sel) =  exp(xx(sel,:)*bb)*12;


MCONTROLS           = [NCOMM./X_PINCT NPURC./X_PINCT ...
                            log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'ORIG'})))./PLEVEL)...
                            gr(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'MDEBT'})))./PLEVEL)...
                            log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'HSTARTS'}))))...
                            gr(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'PCEPI','HPRICE'}))))];
RCONTROLS           = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'GS10','SCONV','TB3','SBAA'})));
CCONTROLS           = [(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'UNRATE'})))) ...
                            gr(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'PINC'})))./PLEVEL)];



