function [RES,ALG]=solveMODEL(PARS,NUM)

% Get Loglinear Approximation and Nonstochastic Steady State
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
PARS.Dshift   = abs(NUM.dmin)+1;
[SS,or,Hll,Gll] = LLModelApprox(PARS);

% Make Grid
%%%%%%%%%%%%
[Za,Pa] = tauchenhussey(NUM.anodes,log(SS.A),PARS.rhoA,PARS.sigmaA,PARS.sigmaA);
 agrid = exp(Za');
[rgridA,Pr] = THMARKOV(NUM.rnodes(1),NUM.rnodes(2),PARS.rss1,PARS.rss2,...
    PARS.rhoR,PARS.sigmaR1,PARS.sigmaR2,PARS.PR_MS,1);
rgrid = (1+rgridA').^0.25;
AGRID=kron(ones(length(rgrid),1),kron(agrid',ones(NUM.Nk,NUM.Nd)));
     RGRID=kron(rgrid',kron(ones(length(agrid),1),ones(NUM.Nk,NUM.Nd)));
     kgrid=linspace(NUM.kmin,NUM.kmax,NUM.Nk);
     dgrid=linspace(NUM.dmin,NUM.dmax,NUM.Nd);
     [kGRID,dGRID]=ndgrid(kgrid,dgrid);
     kGRID=kron(ones(length(AGRID)/NUM.Nk,1),kGRID);
     dGRID=kron(ones(length(AGRID)/NUM.Nk,1),dGRID);  
     PR = sparse(kron(Pr,sparse(kron(Pa,eye(NUM.Nk)))));
CallAGRID = SS.nu*((AGRID.^(PARS.rho/(PARS.rho-1))-PARS.mu*(1+PARS.varphi.*(RGRID-1)./RGRID).^(PARS.rho/(PARS.rho-1)))/(1-PARS.mu)).^((PARS.rho-1)/PARS.rho);    
 
% Start Algorithm
%%%%%%%%%%%%%%%%%%  
% Initial Guess
kpp = SS.K*exp(Gll(or.K,or.K)*log(kGRID/SS.K)+Gll(or.K,or.D)*log((PARS.Dshift+dGRID)/(PARS.Dshift+SS.D))...
    +Gll(or.K,or.A)*log(CallAGRID/SS.CallA)+Gll(or.K,or.R)*log(RGRID*PARS.beta));
dpp = ((SS.D+PARS.Dshift)*exp(Gll(or.D,or.K)*log(kGRID/SS.K)+Gll(or.D,or.D)*log((PARS.Dshift+dGRID)/(PARS.Dshift+SS.D))...
    +Gll(or.D,or.A)*log(CallAGRID/SS.CallA)+Gll(or.D,or.R)*log(RGRID*PARS.beta))-PARS.Dshift);

% Do Iterations
ALGCRIT=1;
tri = delaunay(dGRID(1:NUM.Nk,:),kGRID(1:NUM.Nk,:));

borind = dGRID>0;
R = borind.*RGRID+(1-borind).*min(PARS.Rl,RGRID);

while  ALGCRIT>NUM.TOL;
dpp = min(dpp,PARS.dlim); 
kpp = max(kpp,NUM.kmin); kpp = min(kpp,NUM.kmax);

yp = (CallAGRID.*(PARS.alfa/SS.eta)^(PARS.alfa/(1+PARS.ome))...
    *((1-PARS.alfa)/SS.zeta)^((1-PARS.alfa)/(1+PARS.psi))...
    .*(kGRID/PARS.g).^(PARS.alfa*PARS.ome/(1+PARS.ome))).^(1/(1-PARS.alfa/(1+PARS.ome)-(1-PARS.alfa)/(1+PARS.psi)));
hp = ((1-PARS.alfa)/SS.zeta)^(1/(1+PARS.psi))*yp.^(1/(1+PARS.psi));
up = (PARS.g*PARS.alfa/SS.eta)^(1/(1+PARS.ome))*(yp./kGRID).^(1/(1+PARS.ome));
K_afterdep = (1-SS.delta-SS.eta*up.^(1+PARS.ome)/(1+PARS.ome)).*kGRID/PARS.g;
xp     = kpp-K_afterdep+PARS.phiK/2*(kpp./kGRID-1).^2.*kGRID/PARS.g;
borindp = dpp>0;
Rp = borindp.*RGRID+(1-borindp).*min(PARS.Rl,RGRID);
cp     = yp+dpp./Rp-xp-dGRID/PARS.g;
lamp   = (cp-SS.zeta*hp.^(1+PARS.psi)/(1+PARS.psi)).^(-PARS.gama);
Phip = PARS.phiK/2*((kpp./kGRID).^2-1);

lam  = PARS.beta*(PR*lamp).*R;
LBa  = PARS.beta*PR*(lamp.*(PARS.ome/(1+PARS.ome)*PARS.g*PARS.alfa*yp./kGRID+1-SS.delta+Phip));
k  = kGRID./(1+(LBa./lam-1)*PARS.g/PARS.phiK);
y  = (CallAGRID.*(PARS.alfa/SS.eta)^(PARS.alfa/(1+PARS.ome))...
    *((1-PARS.alfa)/SS.zeta)^((1-PARS.alfa)/(1+PARS.psi))...
    .*(k/PARS.g).^(PARS.alfa*PARS.ome/(1+PARS.ome))).^(1/(1-PARS.alfa/(1+PARS.ome)-(1-PARS.alfa)/(1+PARS.psi)));
h  = ((1-PARS.alfa)/SS.zeta)^(1/(1+PARS.psi))*y.^(1/(1+PARS.psi));
u  = (PARS.g*PARS.alfa/SS.eta)^(1/(1+PARS.ome))*(y./k).^(1/(1+PARS.ome));
x  = kGRID-(1-SS.delta-SS.eta*u.^(1+PARS.ome)/(1+PARS.ome)).*k/PARS.g+PARS.phiK/2*(kGRID./k-1).^2.*k/PARS.g;
c  = lam.^(-1/PARS.gama)+SS.zeta*h.^(1+PARS.psi)/(1+PARS.psi);
d  = PARS.g*(y+dGRID./R-c-x);

kppf = zeros(NUM.Nk,NUM.Nd);
dppf = zeros(NUM.Nk,NUM.Nd);

for n= 1:length(AGRID)/NUM.Nk;
    nn = 1+(n-1)*NUM.Nk:n*NUM.Nk;
kppf(nn,:)  = interptri(tri,d(nn,:),k(nn,:),kGRID(nn,:),dGRID(nn,:),kGRID(nn,:));
dppf(nn,:)  = interptri(tri,d(nn,:),k(nn,:),dGRID(nn,:),dGRID(nn,:),kGRID(nn,:));
kppf(nn,:)  = inpaint_nans(kppf(nn,:),1);
dppf(nn,:)  = inpaint_nans(dppf(nn,:),1);
end 
dppf = min(dppf,PARS.dlim); 
kppf = max(kppf,NUM.kmin); kppf = min(kppf,NUM.kmax);

CRIT  = [abs(kppf-kpp)./(1+abs(kpp)) abs(dppf-dpp)./(1+abs(dpp))];

ALGCRIT  = max(CRIT(:))
kpp=kppf; dpp=dppf; 

end

% Save Results as Structure
RES.PARS = PARS; RES.SS   = SS; RES.agrid= agrid; RES.rgrid= rgrid;
RES.KGRID= kGRID; RES.DGRID= dGRID; RES.Pa  =  Pa; RES.Pr  =  Pr;
RES.kpp =  kpp; RES.dpp =  dpp;