function SIM = simulateMODEL(RES,NUM,PARS,T,Tbi)
 
 SS  = RES.SS;
 Nk  = NUM.Nk(end);
 PR    = kron(RES.Pr,RES.Pa);
 Agrid = kron(ones(length(RES.rgrid),1),RES.agrid');
 Rgrid = kron(RES.rgrid',ones(length(RES.agrid),1));
 Sgrid = [Agrid Rgrid];
 [seq,states] = hmmgenerate2(T,PR,eye(length(PR)));
 tri = delaunay(RES.DGRID(1:Nk,:),RES.KGRID(1:Nk,:));
 
 Aseq = Sgrid(seq,1);
 Rseq = Sgrid(seq,2);
 
 Kseq = zeros(T+1,1);  Dseq = zeros(T+1,1);
 Kseq(1,1) = (NUM.kmax+NUM.kmin)/2;  Dseq(1,1) = 0.5;

 for j= 1:T;
    nn = 1+(seq(j)-1)*Nk:seq(j)*Nk;  
    Kseq(1+j,1) = interptri(tri,RES.KGRID(nn,:),RES.DGRID(nn,:),RES.kpp(nn,:),Kseq(j,1),Dseq(j,1));
    Dseq(1+j,1) = interptri(tri,RES.KGRID(nn,:),RES.DGRID(nn,:),RES.dpp(nn,:),Kseq(j,1),Dseq(j,1));
 end
 
SIM.Dseq = Dseq; 
SIM.Rseq = Rseq;
SIM.Kseq = Kseq;
SIM.CallAseq= SS.nu*((Aseq.^(PARS.rho/(PARS.rho-1))-PARS.mu*(1+PARS.varphi*((Rseq-1)./Rseq)).^(PARS.rho/(PARS.rho-1)))/(1-PARS.mu)).^((PARS.rho-1)/PARS.rho);    
SIM.Yseq = (SIM.CallAseq.*(PARS.alfa/SS.eta)^(PARS.alfa/(1+PARS.ome))...
    *((1-PARS.alfa)/SS.zeta)^((1-PARS.alfa)/(1+PARS.psi))...
    .*(SIM.Kseq(1:T,:)/PARS.g).^(PARS.alfa*PARS.ome/(1+PARS.ome))).^(1/(1-PARS.alfa/(1+PARS.ome)-(1-PARS.alfa)/(1+PARS.psi)));
SIM.Hseq = ((1-PARS.alfa)/SS.zeta)^(1/(1+PARS.psi))*SIM.Yseq.^(1/(1+PARS.psi));
SIM.Useq = (PARS.g*PARS.alfa/SS.eta)^(1/(1+PARS.ome))*(SIM.Yseq./Kseq(1:T,:)).^(1/(1+PARS.ome));
SIM.Xseq = Kseq(2:T+1,:)-(1-SS.delta-SS.eta*SIM.Useq.^(1+PARS.ome)/(1+PARS.ome)).*Kseq(1:T,:)...
    +PARS.phiK/2*(Kseq(2:T+1,:)./Kseq(1:T,:)-1).^2.*Kseq(1:T,:)/PARS.g;
SIM.NXseq= Dseq(1:T,:)/PARS.g-Dseq(2:T+1,:)./Rseq;
SIM.Cseq = SIM.Yseq-SIM.Xseq-SIM.NXseq;
SIM.crisis = (seq>length(Rgrid)/2);


