function [Z,Zprob] = THMARKOV(N1,N2,mu1,mu2,rho,sigma1,sigma2,PR_MS,uR)

ww = 0.5 + rho/4;

sigmaZ1 = sigma1/sqrt(1-rho^2);
baseSigma1 = ww*sigma1 +(1-ww)*sigmaZ1;

sigmaZ2 = sigma2/sqrt(1-rho^2);
baseSigma2 = ww*sigma2 +(1-ww)*sigmaZ2;

inc1 = uR/N1;
Z1=linspace(0-inc1/2,uR+inc1/2,N1);

w1(1)  = quad(@(x)norm_pdf(x,mu1,baseSigma1^2),-20,Z1(1)+inc1/2);
w1(N1) = quad(@(x)norm_pdf(x,mu1,baseSigma1^2),Z1(end)-inc1/2,20);
for j=1:N1-1
w1(1+j)= quad(@(x)norm_pdf(x,mu1,baseSigma1^2),Z1(1+j)-inc1/2,Z1(1+j)+inc1/2);    
end

inc2 = uR/N2;
Z2=linspace(0-inc2/2,uR+inc2/2,N2);

w2(1)  = quad(@(x)norm_pdf(x,mu2,baseSigma2^2),-20,Z2(1)+inc2/2);
w2(N2) = quad(@(x)norm_pdf(x,mu2,baseSigma2^2),Z2(end)-inc2/2,20);
for j=1:N2-1
w2(1+j)= quad(@(x)norm_pdf(x,mu2,baseSigma2^2),Z2(1+j)-inc2/2,Z2(1+j)+inc2/2);    
end
Z1=Z1'; Z2=Z2'; w1=w1'; w2=w2';

sel1 = Z1<0;  sel2 = Z2<0;
sel1u = Z1>uR; sel2u = Z2>uR;
N1 = length(Z1(sel1==0&sel1u==0));
N2 = length(Z2(sel2==0&sel2u==0)); 

Z = [Z1(sel1==0 & sel1u==0);Z2(sel2==0&sel2u==0)];
w = [w1(sel1==0 & sel1u==0)/(1-sum(w1(sel1u==1))-sum(w1(sel1==1))) ; w2(sel2==0 & sel2u==0)/(1-sum(w2(sel2u==1))-sum(w2(sel2==1)))];

for i = 1: N1+N2
w11(i)  = quad(@(x)norm_pdf(x,(1-rho)*mu1 + rho*Z(i),sigma1^2),-20,0);
w12(i)  = quad(@(x)norm_pdf(x,(1-rho)*mu1 + rho*Z(i),sigma1^2),uR,20);
w21(i)  = quad(@(x)norm_pdf(x,(1-rho)*mu2 + rho*Z(i),sigma2^2),-20,0);
w22(i)  = quad(@(x)norm_pdf(x,(1-rho)*mu2 + rho*Z(i),sigma2^2),uR,20);
       for j = 1: N1+N2
            if i<=N1 && j<=N1
            Zprob(i,j) = PR_MS(1,1)*norm_pdf(Z(j),(1-rho)*mu1 + rho*Z(i),sigma1^2)/(1-w11(i)-w12(i))*...
                w(j)*(1-sum(w1(sel1u==1))-sum(w1(sel1==1)))/max(norm_pdf(Z(j),mu1,baseSigma1^2),1e-10);
            elseif i<=N1 && j>N1
            Zprob(i,j) = PR_MS(1,2)*norm_pdf(Z(j),(1-rho)*mu2 + rho*Z(i),sigma2^2)/(1-w21(i)-w22(i))*...
                w(j)*(1-sum(w2(sel2u==1))-sum(w2(sel2==1)))/max(norm_pdf(Z(j),mu2,baseSigma2^2),1e-10);
            elseif i>N1 && j<=N1
            Zprob(i,j) = PR_MS(2,1)*norm_pdf(Z(j),(1-rho)*mu1 + rho*Z(i),sigma1^2)/(1-w11(i)-w12(i))*...
                w(j)*(1-sum(w1(sel1u==1))-sum(w1(sel1==1)))/max(norm_pdf(Z(j),mu1,baseSigma1^2),1e-10);
            elseif i>N1 && j>N1
            Zprob(i,j) = PR_MS(2,2)*norm_pdf(Z(j),(1-rho)*mu2 + rho*Z(i),sigma2^2)/(1-w21(i)-w22(i))*...
                w(j)*(1-sum(w2(sel2u==1))-sum(w2(sel2==1)))/max(norm_pdf(Z(j),mu2,baseSigma2^2),1e-10);
            end
        end
    end


 for i = 1: N1+N2
     Zprob(i,:) = Zprob(i,:) / sum(Zprob(i,:),2);
 end

function c = norm_pdf(x,mu,s2)
    c = 1/sqrt(2*pi*s2) * exp(-(x-mu).^2/2/s2);



