close all

p = 10;

T = length(MOD.SIM.Cseq);
Tbi = 1000;
Gseq=ones(112,1);
for j= 1:111;
    Gseq(1+j,1) = Gseq(j,1)*exp(MOD.RES.PARS.g-1);
end

Y   = reshape(MOD.SIM.Yseq(Tbi+1:end,:),112,(T-Tbi)/112).*(Gseq*ones(1,(T-Tbi)/112));
Ym  = reshape(MOD.SIM.Yseq(Tbi+1-4:end-4,:),112,(T-Tbi)/112).*(Gseq*ones(1,(T-Tbi)/112))/exp(MOD.RES.PARS.g-1)^4;
sel=1:10:length(Y); nsel=length(sel);
YGR = Y(:,sel)./Ym(:,sel)-1;

C   = reshape(MOD.SIM.Cseq(Tbi+1:end,:),112,(T-Tbi)/112).*(Gseq*ones(1,(T-Tbi)/112));
Cm  = reshape(MOD.SIM.Cseq(Tbi+1-4:end-4,:),112,(T-Tbi)/112).*(Gseq*ones(1,(T-Tbi)/112))/exp(MOD.RES.PARS.g-1)^4;
CGR = C(:,sel)./Cm(:,sel)-1;

X   = reshape(MOD.SIM.Xseq(Tbi+1:end,:),112,(T-Tbi)/112).*(Gseq*ones(1,(T-Tbi)/112));
Xm  = reshape(MOD.SIM.Xseq(Tbi+1-4:end-4,:),112,(T-Tbi)/112).*(Gseq*ones(1,(T-Tbi)/112))/exp(MOD.RES.PARS.g-1)^4;
XGR = X(:,sel)./Xm(:,sel)-1;

NXY = reshape(MOD.SIM.NXseq(Tbi+1:end,:)./MOD.SIM.Yseq(Tbi+1:end,:),112,(T-Tbi)/112);
R   = reshape(MOD.SIM.Rseq(Tbi+1:end,:).^4-1,112,(T-Tbi)/112);
NXY = NXY(:,sel);
R   = R(:,sel);

ccorGR = zeros(25,nsel);

for j=1:nsel
corGR  = corr([YGR(:,j) CGR(:,j) XGR(:,j) NXY(:,j) R(:,j)]);
ccorGR(:,j)  = corGR(:);
end

CORGRm = reshape(mean(ccorGR,2),5,5);
CORGRs = reshape(std(ccorGR'),5,5);

Y_gr=exp(DATA.Y(5:end-2))./exp(DATA.Y(1:end-6))-1;
C_gr=exp(DATA.C(5:end-2))./exp(DATA.C(1:end-6))-1;
X_gr=exp((DATA.X(5:end-2)))./exp(DATA.X(1:end-6))-1;
 
%% Table 5 Simulation Results: Year on Year Growth Rates
fprintf('a) Standard Deviations  \n')
fprintf('---------------------- \n')
fprintf('Variable | data | Benchmark \n')
fprintf(' Y    : %f |  %f  \n', [std(Y_gr)*100, mean(std(YGR))*100 ]); 
fprintf(' C    : %f |  %f  \n', [std(C_gr)/std(Y_gr), mean(std(CGR)./std(YGR))]); 
fprintf(' X    : %f |  %f  \n', [std(X_gr)/std(Y_gr), mean(std(XGR)./std(YGR))]); 
fprintf(' NX/Y : %f |  %f  \n\n', [std(DATA.NXY(1:end-2))*100, mean(std(NXY))*100]); 

fprintf('b) Cross-Correlations with g_y \n')
fprintf('------------------------------ \n')
fprintf('Variable | data | Benchmark \n')
fprintf(' C    : %f |  %f  \n',  [corr(C_gr,Y_gr), CORGRm(2,1)]); 
fprintf(' X    : %f |  %f  \n',  [corr(X_gr,Y_gr), CORGRm(3,1)]); 
fprintf(' NX/Y : %f |  %f  \n\n',[corr(DATA.NXY(5:end-2),Y_gr), CORGRm(4,1)]); 

fprintf('c) Cross-Correlations with R \n')
fprintf('------------------------------ \n')
fprintf('Variable | data | Benchmark \n')
fprintf(' Y    : %f |  %f  \n',  [corr(Y_gr(9:end),DATA.R(13:end-2)), CORGRm(1,5)]); 
fprintf(' C    : %f |  %f  \n',  [corr(C_gr(9:end),DATA.R(13:end-2)), CORGRm(2,5)]); 
fprintf(' X    : %f |  %f  \n',  [corr(X_gr(9:end),DATA.R(13:end-2)), CORGRm(3,5)]); 
fprintf(' NX/Y : %f |  %f  \n\n',[corr(DATA.NXY(13:end-2),DATA.R(13:end-2)), CORGRm(4,5)]); 


%% Figure 6 Cross Correlations between GDP growth at various leads and lags, and interest rates
ma = 8;
ACC = zeros(2*ma+1,nsel);
for j=1:nsel
for i = -ma:1:ma
    ACC(1+ma+i,j)=corr(YGR(1+ma:end-ma,j),R(1+ma+i:end-ma+i,j));
end
end
acc  = mean(ACC,2);

for j = -ma:1:ma
    accE(1+ma+j)=corr(Y_gr(9+ma:end-ma),DATA.R(13+ma+j:end-2-ma+j));
end

h3 =figure;
set(gcf,'Color',[1,1,1])
veysup = [prctile((ACC'),100-p)' prctile((ACC'),p)'];
S=-ma:1:ma;
set(gcf,'Color',[1,1,1])
box on;
for i=1:length(S)-1
X=[S(i) S(i) S(i+1) S(i+1)];
Y=[veysup(i,1) veysup(i,2) veysup(i+1,2) veysup(i+1,1)];
if i==1
gg=patch(X,Y,[0.8 0.8 0.8],'EdgeColor','none');
else patch(X,Y,[0.8 0.8 0.8],'EdgeColor','none');
end
end
hold on

p1=plot(-ma:1:ma,acc);
hold on 
p2=plot(-ma:1:ma,accE,'k--');
legend([p1,p2],'model','data')
xlabel('Quarters')
 

%% Figure 7 Autocorrelation function of the trade balance-GDP ratio
ma = 16;
AC = zeros(ma,nsel);
for j=1:nsel
for i = 1:ma
    AC(i,j)=corr(NXY(1+ma:end,j),NXY(1+ma-i:end-i,j));
end
end
ac  = mean(AC,2);

for j = 1:ma
    acE(j)=corr(DATA.NXY(1+ma:end-2),DATA.NXY(1+ma-j:end-j-2));
end
 
h2 =figure;
veysup = [prctile((AC'),100-p)' prctile((AC'),p)'];
S=1:length(ac);
set(gcf,'Color',[1,1,1])
box on;
for i=1:length(S)-1
X=[S(i) S(i) S(i+1) S(i+1)];
Y=[veysup(i,1) veysup(i,2) veysup(i+1,2) veysup(i+1,1)];
if i==1
gg=patch(X,Y,[0.8 0.8 0.8],'EdgeColor','none');
else patch(X,Y,[0.8 0.8 0.8],'EdgeColor','none');
end
end
hold on
p1=plot(ac);
hold on 
p2=plot(acE,'k--');
hold off
legend([p1,p2],'model','data')
xlabel('Lags (Quarters)')

%% Figure 8 Response to a Crisis
CC = (Tbi:T-Tbi)';
TP = CC(((MOD.SIM.crisis(Tbi:T-Tbi)==1 ...
           & MOD.SIM.crisis(Tbi+1:T-Tbi+1)==1 ...
           & MOD.SIM.crisis(Tbi+2:T-Tbi+2)==1 ...
           & MOD.SIM.crisis(Tbi+3:T-Tbi+3)==1 ...
           & MOD.SIM.crisis(Tbi+4:T-Tbi+4)==1 ...
           & MOD.SIM.crisis(Tbi+5:T-Tbi+5)==1 ...
           & MOD.SIM.crisis(Tbi+16:T-Tbi+16)==0 ...
           & MOD.SIM.crisis(Tbi+17:T-Tbi+17)==0 ...
           & MOD.SIM.crisis(Tbi+18:T-Tbi+18)==0 ... 
           & MOD.SIM.crisis(Tbi+19:T-Tbi+19)==0 ... 
           & MOD.SIM.crisis(Tbi+20:T-Tbi+20)==0 ...
           & MOD.SIM.crisis(Tbi-1:T-Tbi-1)==0))',:);   

qua = 20;
quam = 5; 

GGseq=1/exp(MOD.RES.PARS.g-1)^quam;
for j= 1:qua+quam;
    GGseq(1+j,1) = GGseq(j,1)*exp(MOD.RES.PARS.g-1);
end

YCRISIS= zeros(qua+quam+1,length(TP)); NXYCRISIS=zeros(qua+quam+1,length(TP)); 
CCRISIS= zeros(qua+quam+1,length(TP)); ICRISIS=zeros(qua+quam+1,length(TP));
for j=1:length(TP)
YCRISIS(:,j)   = MOD.SIM.Yseq(TP(j)-quam:TP(j)+qua,:).*GGseq;
CCRISIS(:,j)   = MOD.SIM.Cseq(TP(j)-quam:TP(j)+qua,:).*GGseq;
ICRISIS(:,j)   = MOD.SIM.Xseq(TP(j)-quam:TP(j)+qua,:).*GGseq;
NXYCRISIS(:,j) = MOD.SIM.NXseq(TP(j)-quam:TP(j)+qua,:)./MOD.SIM.Yseq(TP(j)-quam:TP(j)+qua,:);
end

TPdata = [41-3 90-3];
YCRISISd= zeros(qua+quam+1,length(TPdata));  NXYCRISISd=zeros(qua+quam+1,length(TPdata)); 
CCRISISd= zeros(qua+quam+1,length(TPdata));  ICRISISd=zeros(qua+quam+1,length(TPdata));
for j=1:length(TPdata)
YCRISISd(:,j)   = exp(DATA.Y(TPdata(j)-quam:TPdata(j)+qua,:))/exp(DATA.Y(TPdata(j)-quam+4,:));
CCRISISd(:,j)   = exp(DATA.C(TPdata(j)-quam:TPdata(j)+qua,:))/exp(DATA.C(TPdata(j)-quam+4,:));
ICRISISd(:,j)   = exp(DATA.X(TPdata(j)-quam:TPdata(j)+qua,:))/exp(DATA.X(TPdata(j)-quam+4,:));
NXYCRISISd(:,j) = DATA.NXY(TPdata(j)-quam:TPdata(j)+qua,:);
end


h0 = figure;
set(gcf,'Color',[1,1,1])
subplot(2,2,1)
scale= mean(YCRISIS(quam,:)); 
aa=prctile((YCRISIS(2:end,:)'),100-p);
ab=prctile((YCRISIS(2:end,:)'),p);
veysup = [prctile((YCRISIS(2:end,:)'),100-p)'/aa(4) prctile((YCRISIS(2:end,:)'),p)'/ab(4)];
box on;
S=-quam+2:qua+1;
for i=1:length(S)-1
X=[S(i) S(i) S(i+1) S(i+1)];
Y=[veysup(i,1) veysup(i,2) veysup(i+1,2) veysup(i+1,1)];
if i==1
gg=patch(X,Y,[0.8 0.8 0.8],'EdgeColor','none');
else patch(X,Y,[0.8 0.8 0.8],'EdgeColor','none');
end
end
hold on
plot(-quam+2:qua+1,mean(YCRISIS(2:end,:),2)/scale,'-','MarkerSize',3,'LineWidth',2)
hold on 
plot(-quam+2:qua+1,YCRISISd(2:end,1),'k--','MarkerSize',3)
hold on 
plot(-quam+2:qua+1,YCRISISd(2:end,2),'k-.','MarkerSize',3)
ylabel('Level')
title('Output')
hold off
axis([-quam+2-0.3 qua+1 0.75 1.35])
vline(0,'k')

subplot(2,2,2)
scale= mean(CCRISIS(quam,:)); 
aa=prctile((CCRISIS(2:end,:)'),100-p);
ab=prctile((CCRISIS(2:end,:)'),p);
veysup = [prctile((CCRISIS(2:end,:)'),100-p)'/aa(4) prctile((CCRISIS(2:end,:)'),p)'/ab(4)];
box on;
for i=1:length(S)-1
X=[S(i) S(i) S(i+1) S(i+1)];
Y=[veysup(i,1) veysup(i,2) veysup(i+1,2) veysup(i+1,1)];
if i==1
gg=patch(X,Y,[0.8 0.8 0.8],'EdgeColor','none');
else patch(X,Y,[0.8 0.8 0.8],'EdgeColor','none');
end
end
hold on
plot(-quam+2:qua+1,mean(CCRISIS(2:end,:),2)/scale,'-','MarkerSize',3,'LineWidth',2)
hold on 
plot(-quam+2:qua+1,CCRISISd(2:end,1),'k--','MarkerSize',3)
hold on 
plot(-quam+2:qua+1,CCRISISd(2:end,2),'k-.','MarkerSize',3)
hold on 
vline(0,'k')
title('Consumption')
hold off
axis([-quam+2-0.3 qua+1 0.75 1.35])

subplot(2,2,3)
scale= mean(ICRISIS(quam,:)); 
aa=prctile((ICRISIS(2:end,:)'),100-p);
ab=prctile((ICRISIS(2:end,:)'),p);
veysup = [prctile((ICRISIS(2:end,:)'),100-p)'/aa(4) prctile((ICRISIS(2:end,:)'),p)'/ab(4)];
box on;
for i=1:length(S)-1
X=[S(i) S(i) S(i+1) S(i+1)];
Y=[veysup(i,1) veysup(i,2) veysup(i+1,2) veysup(i+1,1)];
if i==1
gg=patch(X,Y,[0.8 0.8 0.8],'EdgeColor','none');
else patch(X,Y,[0.8 0.8 0.8],'EdgeColor','none');
end
end
hold on
plot(-quam+2:qua+1,mean(ICRISIS(2:end,:),2)/scale,'-','MarkerSize',3,'LineWidth',2)
hold on 
plot(-quam+2:qua+1,ICRISISd(2:end,1),'k--','MarkerSize',3)
hold on 
plot(-quam+2:qua+1,ICRISISd(2:end,2),'k-.','MarkerSize',3)
hold on 
vline(0,'k')
xlabel('quarters') 
ylabel('Level')
title('Investment')
hold off
axis([-quam+2-0.3 qua+1 0.45 1.65])

subplot(2,2,4)
aa=prctile((NXYCRISIS(2:end,:)'),100-p);
ab=prctile((NXYCRISIS(2:end,:)'),p);
ac=mean(NXYCRISIS(2:end,:),2);
veysup = [aa'-(aa(4)-ac(4)) ab'-(ab(4)-ac(4))];
box on;
for i=1:length(S)-1
X=[S(i) S(i) S(i+1) S(i+1)];
Y=[veysup(i,1) veysup(i,2) veysup(i+1,2) veysup(i+1,1)];
if i==1
gg=patch(X,Y,[0.8 0.8 0.8],'EdgeColor','none');
else patch(X,Y,[0.8 0.8 0.8],'EdgeColor','none');
end
end
hold on 
p1=plot(-quam+2:qua+1,mean(NXYCRISIS(2:end,:),2),'-','MarkerSize',3,'LineWidth',2);
hold on 
p2=plot(-quam+2:qua+1,NXYCRISISd(2:end,1)','k--','MarkerSize',3);
hold on 
p3=plot(-quam+2:qua+1,NXYCRISISd(2:end,2)','k-.','MarkerSize',3);
vline(0,'k')
xlabel('quarters') 
title('NX/Y')
hold off
axis([-quam+2-0.3 qua+1 -0.05 0.15]);
legend([p1,p2,p3],'model','1989Q1','2001Q2');
