% Regime-Switching Interest Rates and Fluctuations in Emerging Markets
% by Bertrand Gruss and Karel Mertens, March 2010

clear all; close all; options_pub.format='latex'; options_pub.showCode=false;
addpath('auxiliaryfiles')

%Load Data for Graphs
data = xlsread('DATA_GM2009.xls'); 
DATA.Y  = log(data(:,1)); DATA.C  = log(data(:,2)); 
DATA.X  = log(data(:,3)); DATA.NXY = data(:,4); DATA.R  = data(:,5); 

%% Model Parameters
%%%%%%%%%%%%%%%%%%%
PARS.alfa  = 0.38;          % capital share in GDP
PARS.beta  = 0.9598;        % discount factor
PARS.g     = 1.0083;        % trend growth factor
PARS.psi   = 0.6;           % inverse of wage elasticity of labor supply
PARS.phiK  = 19.3*2;        % capital adjustment cost parameter
PARS.ome   = 0.44;          % depreciation elasticity parameter
PARS.gama  = 2;             % utility curvature parameter
PARS.rho = (0.0001-1)/0.0001;  % technology parameter determining production substitution elasticity
PARS.mu = 0.442;            % intermediate inputs weight
PARS.varphi = 1;            % finance constraint parameter
PARS.dlim  = 4;             % debt limit
PARS.rhoA  = 0.95;          % persistence of productivity shock
PARS.sigmaA = 0.0027;       % sdev of productivity shock
PARS.rhoR  = 0.91987;       % persistence of interest rate process
PARS.rss1 = 0.050285; PARS.sigmaR1 = 0.016839; %Regime 1
PARS.rss2 = 0.20979;  PARS.sigmaR2 = 0.14397;  %Regime 2
PARS.PR_MS = [0.91377 0.086233; 0.3685 0.6315]; % Markov Transition Matrix
PARS.Rl = 1.02^0.25;        % upper bound on interest rate
PARS.IY = 0.2225;           % auxiliary parameter to target investment-output ratio
%% Numerical Solution and Simulation Parameters: 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
NUM.Nk = [21];   NUM.Nd = NUM.Nk;  NUM.TOL = [1.e-8]; 
NUM.anodes = 11;  NUM.rnodes = [51 51]; NUM.kmin = 2.7; NUM.kmax = 7.8; NUM.dmin = -0.05; NUM.dmax = 1.5;
Tbi = 1000; T = 10000*112+Tbi;

%% Solve Baseline Model:
%%%%%%%%%%%%%%%%%%%%%%%% 
MOD.RES=solveMODEL(PARS,NUM);
MOD.SIM=simulateMODEL(MOD.RES,NUM,PARS,T,Tbi);
save('MOD.mat','MOD')

 
%% Produce Tex file with Results
options_pub.outputDir='RESULTS';
publish('Report.m',options_pub)
 


 

