function [SS,or,H,G] = LLModelApprox(PARS);

% Steady State (output, hours and utilization rate are normalized to one)
SS.Y=1; SS.h=1; SS.u=1; SS.A=1; SS.D=0.5;

SS.zeta  = (1-PARS.alfa)*SS.Y*SS.h^(-1-PARS.psi);
SS.NXY   = (1/PARS.g-1/PARS.beta)*SS.D/SS.Y;
SS.dep   = 1-(1/PARS.beta-PARS.alfa*PARS.g/PARS.IY)/(1-PARS.alfa/PARS.IY);
SS.K     = PARS.IY/(1-(1-SS.dep)/PARS.g)*SS.Y;
SS.X     = PARS.IY*SS.Y;
SS.eta   = PARS.g*PARS.alfa*SS.Y/SS.K;
SS.delta = SS.dep-SS.eta/(1+PARS.ome);
SS.C     = SS.Y-SS.X-SS.NXY;
SS.lam   = (SS.C-SS.zeta*SS.h^(1+PARS.psi)/(1+PARS.psi))^-PARS.gama;
SS.nu    = ((1-PARS.mu*(1+PARS.varphi*(1-PARS.beta))^(PARS.rho/(PARS.rho-1)))/(1-PARS.mu))^((1-PARS.rho)/PARS.rho)...
              *(SS.h)^(PARS.alfa-1)*(SS.u*SS.K/PARS.g)^(-PARS.alfa);
SS.CallA = SS.nu*((1-PARS.mu*(1+PARS.varphi*(1-PARS.beta))^(PARS.rho/(PARS.rho-1)))/(1-PARS.mu))^((PARS.rho-1)/PARS.rho);          

or.K=1; or.D=2; or.A=3; or.R=4;
or.Y=1; or.C=2; or.X=3; or.h=4; or.lam=5; or.u=6; or.Kf=7;

Fx = zeros(or.R+or.Kf,or.R);
Fxp = zeros(or.R+or.Kf,or.R);
Fy = zeros(or.R+or.Kf,or.Kf);
Fyp = zeros(or.R+or.Kf,or.Kf);

%1. SS.zeta*h^PARS.psi=(1-PARS.alfa)*Y/h;
eqn=1;
Fy(eqn,or.h)  = -(1+PARS.psi);
Fy(eqn,or.Y)  = 1;

%2. SS.eta*u^PARS.ome=g*PARS.alfa*Y/u/K;
eqn=2;
Fy(eqn,or.u)  = -(1+PARS.ome);
Fy(eqn,or.Y)  = 1;
Fx(eqn,or.K)  = -1;

%3.lam=beta*lamp*R;
eqn=3;
Fy(eqn,or.lam)  = -1;
Fxp(eqn,or.D)  = 0.000001*PARS.beta;
Fx(eqn,or.R) = 1;
Fyp(eqn,or.lam) = 1;

%4.lam=(SS.C-SS.zeta*SS.h^(1+PARS.psi)/(1+PARS.psi))^-PARS.gama;
eqn=4;
Fy(eqn,or.lam)  = -1;
Fy(eqn,or.C)    = -PARS.gama*SS.C/(SS.C-SS.zeta*SS.h^(1+PARS.psi)/(1+PARS.psi));
Fy(eqn,or.h)    = PARS.gama*SS.zeta*SS.h^(1+PARS.psi)/(SS.C-SS.zeta*SS.h^(1+PARS.psi)/(1+PARS.psi));

%5.lam*(1+PARS.phiK/g*(Kp/K-1))=beta*lamp*(g*PARS.alfa*Yp/Kp+1-SS.delta-SS.eta*u^(1+PARS.ome)/(1+PARS.ome)+Phip);
eqn=5;
Fy(eqn,or.lam)  = -1;
Fx(eqn,or.K)    = PARS.phiK/PARS.g;
Fyp(eqn,or.lam) = 1;
Fyp(eqn,or.Y)   = PARS.g*PARS.alfa*PARS.beta*SS.Y/SS.K;
Fyp(eqn,or.u)   = -PARS.beta*SS.eta;
Fyp(eqn,or.Kf)  =  PARS.beta*PARS.phiK;
Fxp(eqn,or.K)   = -PARS.phiK/PARS.g-PARS.beta*PARS.phiK-PARS.g*PARS.alfa*PARS.beta*SS.Y/SS.K;

%6. Kp=X+(1-SS.delta-SS.eta*u^(1+PARS.ome)/(1+PARS.ome))*K/g-PARS.phiK/2*(Kp/K-PARS)^2*K/g;
eqn=6;
Fxp(eqn,or.K) = -1;
Fx(eqn,or.K)  = (1-SS.delta-SS.eta)/PARS.g;
Fy(eqn,or.u)  = -SS.eta/PARS.g;
Fy(eqn,or.X)   = SS.X/SS.K;

%7. Y=A*(u*K/g)^(PARS.alfa)*(h)^(1-PARS.alfa);
eqn=7;
Fy(eqn,or.Y)  = -1;
Fx(eqn,or.A)  = 1;
Fy(eqn,or.u)  = PARS.alfa;
Fx(eqn,or.K)  = PARS.alfa;
Fy(eqn,or.h)  = 1-PARS.alfa;

%8. d/g+c+x=y+dp/R
eqn=8;
Fx(eqn,or.D)  = -(SS.D+PARS.Dshift)/PARS.g/SS.Y;
Fy(eqn,or.C)  = -SS.C/SS.Y;
Fy(eqn,or.X)  = -SS.X/SS.Y;
Fy(eqn,or.Y)  =  1;
Fxp(eqn,or.D)  = (SS.D+PARS.Dshift)/SS.Y*PARS.beta;
Fx(eqn,or.R)  =  -SS.D/SS.Y*PARS.beta;

%9.Kf=Kp;
eqn=9;
Fy(eqn,or.Kf)  = -1;
Fxp(eqn,or.K)  = 1;

%10.A;
eqn=10;
Fxp(eqn,or.A)  = -1;
Fx(eqn,or.A)  = PARS.rhoA;

%11.R;
eqn=11;
Fxp(eqn,or.R)  = -1;
Fx(eqn,or.R)  = 0;

[H,G]=solab([-Fxp -Fyp],[Fx Fy],size(Fx,2)); 

